<?php
session_start();
$user = null; // Initialize $user to null

// Database connection settings for login_db
$host = "localhost";
$dbname = "login_db";    // Use only login_db, which contains both 'user' and 'artists' tables
$username = "root";      // Replace with your actual database username if different
$password = "";          // Replace with your actual database password if any

// Connect to the login_db database
$mysqli = new mysqli($host, $username, $password, $dbname);

// Check for connection errors
if ($mysqli->connect_error) {
    die("Connection failed: " . $mysqli->connect_error);
}

// Check if the user is logged in
if (isset($_SESSION["user_id"])) {
    // Use prepared statement to fetch user data safely
    $sql = "SELECT * FROM user WHERE id = ?";
    $stmt = $mysqli->prepare($sql);
    $stmt->bind_param("i", $_SESSION["user_id"]);
    $stmt->execute();
    $result = $stmt->get_result();
    $user = $result->fetch_assoc();
    $stmt->close();
}

// Fetch all artist profiles from the artists table in login_db
$sql = "SELECT * FROM artists";
$result = $mysqli->query($sql);
$artists = [];
if ($result) {
    while ($row = $result->fetch_assoc()) {
        $artists[] = $row;
    }
}
$mysqli->close();
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="stylesheet" href="style.css">
    <title>ArloMusic - Artists</title>
    <style>
        /* Container for grid layout */
        .HeaderLow {
            display: grid;
            grid-template-columns: repeat(auto-fill, minmax(250px, 1fr));
            gap: 20px;
            padding: 20px;
            background-color: transparent;
            justify-items: center;
        }

        /* Artist card styling */
        .container1 {
            background-color: transparent;
            border-radius: 15px;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
            width: 100%;
            max-width: 300px;
            padding: 20px;
            display: flex;
            align-items: center;
            gap: 15px;
            transition: transform 0.3s ease;
            overflow: hidden;
            box-sizing: border-box;
        }

        /* Hover effect on artist card */
        .container1:hover {
            transform: scale(1.03);
            box-shadow: 0 6px 12px rgba(0, 0, 0, 0.2);
        }

        /* Circular image styling */
        .artist-image {
            flex-shrink: 0;
            width: 60px;
            height: 60px;
            border-radius: 50%;
            background-color: #d3d3d3;
            overflow: hidden;
        }

        .artist-image img {
            width: 100%;
            height: 100%;
            object-fit: cover;
        }

        /* Artist text styling */
        .artist-info {
            flex: 1;
            overflow: hidden;
        }

        .artist-info p {
            margin: 0;
            font-size: 1rem;
            color: white;
            text-overflow: ellipsis;
            overflow: hidden;
            white-space: nowrap;
        }

        .artist-info .artist-name {
            font-weight: bold;
            margin-bottom: 5px;
            color: white;
        }

        /* Styling for upload button */
        .upload-button {
            padding: 10px 15px;
            background-color: #007bff;
            color: white;
            border: none;
            border-radius: 5px;
            margin-right: 2%;
            cursor: pointer;
            transition: background-color 0.3s;
        }

        .upload-button:hover {
            background-color: #0056b3;
        }

        /* Modal styling */
        .modal {
            display: none;
            position: fixed;
            z-index: 1;
            left: 0;
            top: 0;
            width: 100%;
            height: 100%;
            background-color: rgba(0, 0, 0, 0.5);
        }
        
        .modal-content {
            background-color: #fff;
            margin: 15% auto;
            padding: 20px;
            border-radius: 5px;
            width: 80%;
            max-width: 500px;
            text-align: center;
        }
        
        .close-button {
            float: right;
            font-size: 28px;
            font-weight: bold;
            cursor: pointer;
        }
        
        .close-button:hover {
            color: #000;
        }

        .modal {
            display: none;
            position: fixed;
            z-index: 1;
            left: 0;
            top: 0;
            width: 100%;
            height: 100%;
            background-color: rgba(0, 0, 0, 0.6);
            backdrop-filter: blur(4px);
        }
        
        .modal-content {
            background-color: #2c3e50;
            color: white;
            margin: 10% auto;
            padding: 20px;
            border-radius: 8px;
            width: 90%;
            max-width: 400px;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.3);
        }
        
        .close-button {
            float: right;
            font-size: 1.5rem;
            font-weight: bold;
            color: #ccc;
            cursor: pointer;
        }
        
        .close-button:hover {
            color: #fff;
        }

        /* Form styling */
        .modal-content form {
            display: flex;
            flex-direction: column;
            gap: 15px;
        }

        .modal-content label {
            font-weight: normal;
            font-family: system-ui, -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, Oxygen, Ubuntu, Cantarell, 'Open Sans', 'Helvetica Neue', sans-serif;
            font-size: 0.9rem;
            color: #ddd;
        }

        .modal-content input[type="text"],
        .modal-content textarea,
        .modal-content input[type="file"] {
            width: 100%;
            padding: 10px;
            border-radius: 5px;
            border: 1px solid #ccc;
            box-sizing: border-box;
            background-color: #34495e;
            color: white;
        }

        .modal-content textarea {
            resize: vertical;
        }

        .modal-content button[type="submit"] {
            padding: 10px 15px;
            background-color: #27ae60;
            color: white;
            border: none;
            border-radius: 5px;
            cursor: pointer;
            font-size: 1rem;
            font-weight: bold;
            transition: background-color 0.3s;
        }

        .modal-content button[type="submit"]:hover {
            background-color: #1e8449;
        }
        h2{
            font-family: system-ui, -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, Oxygen, Ubuntu, Cantarell, 'Open Sans', 'Helvetica Neue', sans-serif;
        }
        @media (max-width: 768px) {
    html, body {
    overflow-x: hidden;
}
       /* Hamburger icon styles */
       .hamburger {
    display: none;
    cursor: pointer;
    flex-direction: column;
    gap: 5px;
    padding: 10px;
    z-index: 10; /* Make sure the hamburger icon stays above the menu */
}

.hamburger .bar {
    width: 25px;
    height: 3px;
    background-color: white;
    transition: 0.4s;
}

    .nav-links {
        position: fixed;
        top: 0px;
        right: -60%; /* Start off-screen */
        height: 100vh;
        width: 40%; /* Cover half the screen */
        background-color: #000000c7;
        border-left: 0.5px solid white;
        display: flex;
        flex-direction: column;
        justify-content: center;
        align-items: center;
        text-align: center;
        transition: right 0.4s ease; /* Smooth slide-in effect */
        z-index: 9; /* Keep the menu below the hamburger icon */
    }

    .nav-links ul {
        flex-direction: column;
        width: 100%;
    }

    .nav-links ul li {
        display: block;
        padding: 15px 0;
    }

    /* Show hamburger icon only on mobile */
    .hamburger {
        display: flex;
    }

    /* When active, slide the menu into view */
    .nav-links.active {
        right: -7%;
    }

.hamburger {
        display: flex;
        position: relative; /* Keeps it at the top right of the screen initially */
        right: 10px;
        z-index: 11; /* Above the menu */
    }

    /* Position hamburger icon "inside" menu when it’s open */
    .hamburger.active {
        position: fixed; /* Repositions icon relative to .nav-links */

        right: 10px;
        z-index: 11; /* Above the sliding menu content */
    }
    .Account{
        margin-left: -20px;
        margin-top: 10px;
    }
    .modal-content {
            background-color: #2c3e50;
            color: white;
            margin: 10% auto;
            padding: 20px;
            border-radius: 8px;
            margin-top: 100px;
            width: 100%;
            max-width: 350px;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.3);
        }
        .modal {
            display: none;
            position: fixed;
            z-index: 1;
            left: 0;
            top: 0;
            width: 100%;
            height: 100%;
            background-color: rgba(0, 0, 0, 0.6);
            backdrop-filter: blur(4px);
        }
    
} 
    </style>
</head>
<body>
    <section class="header" id="NavSection">
        <nav class="navbar">
            <a href="Logged.php"><img class="LogoIcon" src="Images/Logo1.png" alt="ArloMusic_Logo"></a>
            <div class="hamburger" id="hamburger" onclick="toggleMenu()">
        <div class="bar"></div>
        <div class="bar"></div>
        <div class="bar"></div>
            </div>
            <div class="nav-links" id="navLinks">
                <ul>
                <li class="navButton"><a href="index.php">Home</a></li>
                <li class="navButton"><a href="TopPage.php">Top</a></li>
                <li class="navButton"><a href="">Artists</a></li>
                <li class="navButton"><a class href="AccountCreate.php">Sign up</a></li>
                <li class="navButton"><a href="AccountLogin.php">Log in</a></li>
                </ul>
            </div>
            
        </nav>

        <div class="HeaderLow">
            <?php foreach ($artists as $artist): ?>
                <div class="container1">
                    <div class="artist-image">
                        <img src="<?php echo htmlspecialchars($artist['image_path']); ?>" alt="<?php echo htmlspecialchars($artist['artist_name']); ?>">
                    </div>
                    <div class="artist-info">
                        <p class="artist-name"><?php echo htmlspecialchars($artist['artist_name']); ?></p>
                        <p><?php echo htmlspecialchars($artist['description']); ?></p>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>
        <br>
    </section>
    <hr>
    <section class="Footer">
    <div class="FooterContent">
        <div class="FooterLinks">
            <ul>
            <li><a href="index.php">About Us</a></li>
                    <li><a href="contact.php">Contact Us</a></li>
                    <li><a href="policy.php">Privacy Policy</a></li>
                    <li><a href="TOS.php">Terms of Service</a></li>
            </ul>
        </div>
        <div class="FooterSocials">
            <ul>
                <li><a href=""><img src="Images/facebook.png" alt=""></a></li>
                <li><a href=""><img src="Images/twitter.png" alt=""></a></li>
                <li><a href=""><img src="Images/instagram.png" alt=""></a></li>
            </ul>
        </div>
    </div>
    <h1>Copyright © 2024 ArloMusic All rights reserved.</h1>
</section>

    <!-- Modal for Upload Profile -->
    <div id="uploadModal" class="modal">
        <div class="modal-content">
            <span class="close-button" onclick="closeModal()">&times;</span>
            <h2>Upload Your Profile</h2>
            <form action="upload_profile.php" method="POST" enctype="multipart/form-data">
                <label for="artistName">Artist Name:</label>
                <input type="text" id="artistName" name="artistName" required>

                <label for="description">Description:</label>
                <textarea id="description" name="description" required></textarea>

                <label for="profileImage">Profile Image:</label>
                <input type="file" id="profileImage" name="profileImage" accept="image/*" required>

                <button type="submit">Submit Profile</button>
            </form>
        </div>
    </div>

    <script>
        // Open modal
        function openModal() {
            document.getElementById("uploadModal").style.display = "block";
        }
        
        // Close modal
        function closeModal() {
            document.getElementById("uploadModal").style.display = "none";
        }
        
        // Close modal if clicking outside of it
        window.onclick = function(event) {
            if (event.target == document.getElementById("uploadModal")) {
                closeModal();
            }
        };
    </script>
    <script>
    function toggleMenu() {
        const navLinks = document.getElementById("navLinks");
        navLinks.classList.toggle("active");
        const hamburger = document.getElementById("hamburger");
        hamburger.classList.toggle("active");
    }
</script>
</body>
</html>
